implementation module StdDynamic

import StdFile
import StdEnv
from StdBool import not;
import StdArray

:: T_ypeObjectType
	= T_ypeConsSymbol {#Char} [T_ypeObjectType]
	| P_laceholder (T_ypeObjectType -> T_ypeObjectType) (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	| Dummy

/****************************************************************************************\
****
****			U n i f y
****
\****************************************************************************************/


_unify :: !T_ypeObjectType !T_ypeObjectType -> (Bool, [T_ypeObjectType])
_unify type1 type2 = code {
	||================================================================================
	||
	|| calling conventions:
	||    - type pattern on top of a-stack
	||    - type tag just below this
	||
	|| The type tag is the field of the dynamic argument that contains a type,
	|| the type pattern is the type that must be matched against.
	||
	|| return conventions:
	||    - boolean result of the unification on top of the a-stack
	||    - indirection-list just below this
	||
	|| The boolean node contains TRUE if the unification is successful,
	||   otherwise it contains FALSE.
	|| In either case, the indirection list (build with _Cons and _nil)
	||   contains a list of pointers to parts of the type pattern and type
	||   tag where placeholders have been replaced by types.
	||
	||================================================================================
	||
	||	.export T_ypeConsSymbol
	||	.export P_laceholder
	||	.export _unify
	||	.export S_uccess
	||	.export F_ail
	||	.desc T_ypeConsSymbol _hnf _add_arg 2 "TypeCons"	|| TypeCons Definition [Type]
	||	.desc P_laceholder	  _hnf _add_arg 3 "Placeholder"	|| Placeholder (Type -> Type) (Type -> Type) Type
	||	.desc _TypeInd		  _hnf _add_arg 2 "Indirection"	|| TypeInd Type Ind
	||	.impdesc _Cons
	||	.impdesc _Nil
	.implab e_StdMisc_sabort 
	||
	||=================
	||   abort call
	||=================
			jmp _unify
	:_maRCo_abort
			jmp e_StdMisc_sabort
		
	||=================
	||   Unify types
	||=================
	.o 2 0
	:_unify
	:_create_indirectionlist		||  Tt  |  Tp
			push_a 0				||  Tt  |  Tp  |  Tp
			update_a 2 1			||  Tt  |  Tt  |  Tp
			build _Nil 0 _hnf		||  Tt  |  Tt  |  Tp  |  Nil
			update_a 0 3			||  Nil |  Tt  |  Tp  |  Nil
			pop_a 1					||  Nil |  Tt  |  Tp
	.d 3 0
			jsr _unify_types
	.o 1 1 b						||  ind_list
			buildB_b 0				||  ind_list | bool
			pop_b 1
	.d 2 0
			rtn

	
	||===================================
	||   Identify kind of Type Pattern
	||===================================
	.o 3 0
	:_unify_types
			eq_desc e_StdDynamic_dT_ypeConsSymbol 2 0
			jmp_true _isType
			eq_desc e_StdDynamic_dP_laceholder 2 0		|| was: eq_desc e_StdDynamic_dP_laceholder 3 0
			jmp_true _substitutePatternVariable
			buildAC "StdDynamics: Unknown type in dynamic pattern"
			jmp _maRCo_abort

	||===============================
	||   Identify kind of Type Tag
	||===============================
	:_isType
			eq_desc e_StdDynamic_dT_ypeConsSymbol 2 1
			jmp_true _compareDefinition
			eq_desc e_StdDynamic_dP_laceholder 2 1		|| was: eq_desc e_StdDynamic_dP_laceholder 3 1
			jmp_true _substituteTagVariable
			buildAC "StdDynamics: Unknown type in dynamic tag !!!!"
			jmp _maRCo_abort

	||=============================
	||   Compare type definition
	||=============================
	:_compareDefinition
			push_arg 1 2 1			|| push type definition of type tag	
			push_arg 1 2 1			|| push type definition of type pattern
			push_arg 1 1 1			|| push String of type tag	
			push_arg 1 1 1			|| push String of type pattern
	.d 2 0
			jsr eqAC
	.o 0 1 b
			pop_a 2					|| pop type definitions
			jmp_true _compareTypeArguments
			jmp _noMatch3
	
	||==========================
	||   unify type arguments
	||==========================
	:_compareTypeArguments
			push_a 2				|| push (a ptr to) the indirectionlist
			push_arg 2 2 2			|| push type arguments of type tag	
			push_arg 2 2 2			|| push type arguments of type pattern
	:_checkArgumentList
			jsr_eval	0			|| reduce to whnf
			jsr_eval	1			|| reduce to whnf
			
			eq_desc _Cons 2 1
			jmp_true _isConsTag
			eq_desc _Nil 0 0		|| check whether pattern is also _Nil
			jmp_true _isMatch6
			jmp _noMatch6

	:_isConsTag
			eq_desc _Cons 2 0		|| check whether pattern is also _Cons
			jmp_false _noMatch6

	:_compareFirstArgument
			push_a 2				|| push (a ptr to the) indirectionlist
			push_arg 2 2 1			|| push first argument of type tag	
			push_arg 2 2 1			|| push first argument of type pattern
	.d 3 0
			jsr _unify_types
	.o 1 1 b
			update_a 0 3			|| update (ptr to the) indirectionlist
			pop_a 1					|| pop (ptr to the) indirectionlist
			jmp_false _noMatch6
	:_compareRestOfArguments
			push_arg 1 2 2			|| push next arguments of type tag	
			push_arg 1 2 2			|| push next arguments of type pattern
			update_a 1 3
			update_a 0 2
			pop_a 2
			jmp _checkArgumentList

	||======================================
	||   substitute type pattern variable
	||======================================
	:_substitutePatternVariable
								|| ind_list              | tag | pat=var
			push_a 2			|| ind_list              | tag | pattern | ind_list
			push_a 1			|| ind_list              | tag | pattern | ind_list | pattern
			build _Cons 2 _hnf	|| ind_list              | tag | pattern | Cons pattern ind_list
			update_a 0 3		|| Cons pattern ind_list | tag | pattern | Cons pattern ind_list
			pop_a 1				|| Cons pattern ind_list | tag | pattern
			fill_a 1 0			|| Cons pattern ind_list | tag | tag
			jmp _isMatch3

	||======================================
	||   substitute type tag variable
	||======================================
	:_substituteTagVariable
	||		print "_substituteTagVariable\n"
								|| ind_list          | tag=var | pattern
			push_a 2			|| ind_list          | tag     | pattern | ind_list
			push_a 2			|| ind_list          | tag     | pattern | ind_list | tag
			build _Cons 2 _hnf	|| ind_list          | tag     | pattern | Cons tag ind_list
			update_a 0 3		|| Cons tag ind_list | tag     | pattern | Cons tag ind_list
			pop_a 1				|| Cons tag ind_list | tag     | pattern
			fill_a 0 1			|| Cons tag ind_list | pattern | pattern
			jmp _isMatch3


	||=========================
	||   types are unifiable
	||=========================
	:_isMatch6
			update_a 2 5			|| copy indirectionpointer
			pop_a 3					|| remove arguments
	:_isMatch3
			pop_a 2					|| remove types
			pushB TRUE
	.d 1 1 b
			rtn
	||=============================
	||   types are not unifiable
	||=============================
	:_noMatch6
			update_a 2 5			|| copy indirectionpointer
			pop_a 3					|| remove arguments
	:_noMatch3
			pop_a 2					|| remove types
			pushB FALSE
	.d 1 1 b
			rtn
	||===================
	||   unknown value
	||===================
	:_unknownValue
			buildAC "StdDynamics: Unknown Value in dynamic"
			jmp _maRCo_abort
	}

/****************************************************************************************\
****
****			C o e r c e
****
\****************************************************************************************/


_coerce :: !T_ypeObjectType !T_ypeObjectType -> (Bool, [T_ypeObjectType])
_coerce type1 type2 = code {
	||================================================================================
	||
	|| calling conventions:
	||    - type pattern on top of a-stack		(type1)
	||    - type tag just below this			(type2) 
	|| 
	|| coerce type1 type2 if type1 is coercible to type2 i.e. type
	||
	|| The type tag is the field of the dynamic argument that contains a type,
	|| the type pattern is the type that must be coerced.
	||
	|| return conventions:
	||    - boolean result of the coercion on top of the a-stack
	||    - indirection-list just below this
	||
	|| The boolean node contains TRUE if the coercion is successful,
	||   otherwise it contains FALSE.
	|| In either case, the indirection list (build with _Cons and _nil)
	||   contains a list of pointers to parts of the type pattern
	||   where placeholders have been replaced by types from the type tag.
	||
	||================================================================================
	||
	||	.export T_ypeConsSymbol
	||	.export P_laceholder
	||	.export _unify
	||	.export S_uccess
	||	.export F_ail
	||	.desc T_ypeConsSymbol _hnf _add_arg 2 "TypeCons"	|| TypeCons Definition [Type]
	||	.desc P_laceholder	  _hnf _add_arg 3 "Placeholder"	|| Placeholder (Type -> Type) (Type -> Type) Type
	||	.desc _TypeInd		  _hnf _add_arg 2 "Indirection"	|| TypeInd Type Ind
	||	.impdesc _Cons
	||	.impdesc _Nil
||	.implab e_StdMisc_sabort
	||
	||=================
	||   abort call
	||=================
			jmp _coerce1
	:_maRCo_abort1
			jmp e_StdMisc_sabort
		
	||=================
	||   Coerce types
	||=================
	.o 2 0
	:_coerce1
	:_create_indirectionlist1		||  Tt  |  Tp
			push_a 0				||  Tt  |  Tp  |  Tp
			update_a 2 1			||  Tt  |  Tt  |  Tp
			build _Nil 0 _hnf		||  Tt  |  Tt  |  Tp  |  Nil
			update_a 0 3			||  Nil |  Tt  |  Tp  |  Nil
			pop_a 1					||  Nil |  Tt  |  Tp
	.d 3 0
			jsr _unify_types1
	.o 1 1 b						||  ind_list
			buildB_b 0				||  ind_list | bool
			pop_b 1
	.d 2 0
			rtn

	
	||===================================
	||   Identify kind of Type Pattern
	||===================================
	.o 3 0
	:_unify_types1
			eq_desc e_StdDynamic_dT_ypeConsSymbol 2 0
			jmp_true _isType1
			eq_desc e_StdDynamic_dP_laceholder 2 0		|| was: eq_desc e_StdDynamic_dP_laceholder 3 0
			jmp_true _substitutePatternVariable1
			buildAC "StdDynamics: Unknown type in dynamic pattern"
			jmp _maRCo_abort1

	||===============================
	||   Identify kind of Type Tag
	||===============================
	:_isType1
			eq_desc e_StdDynamic_dT_ypeConsSymbol 2 1
			jmp_true _compareDefinition1
			eq_desc e_StdDynamic_dP_laceholder 2 1		|| was: eq_desc e_StdDynamic_dP_laceholder 3 1
			jmp_true _substituteTagVariable1
			buildAC "StdDynamics: Unknown type in dynamic tag !!!!"
			jmp _maRCo_abort1

	||=============================
	||   Compare type definition
	||=============================
	:_compareDefinition1
			push_arg 1 2 1			|| push type definition of type tag	
			push_arg 1 2 1			|| push type definition of type pattern
			push_arg 1 1 1			|| push String of type tag	
			push_arg 1 1 1			|| push String of type pattern
	.d 2 0
			jsr eqAC
	.o 0 1 b
			pop_a 2					|| pop type definitions
			jmp_true _compareTypeArguments1
			jmp _noMatch31
	
	||==========================
	||   unify type arguments
	||==========================
	:_compareTypeArguments1
			push_a 2				|| push (a ptr to) the indirectionlist
			push_arg 2 2 2			|| push type arguments of type tag	
			push_arg 2 2 2			|| push type arguments of type pattern
	:_checkArgumentList1
			jsr_eval	0			|| reduce to whnf
			jsr_eval	1			|| reduce to whnf

			eq_desc _Cons 2 1
			jmp_true _isConsTag1
			eq_desc _Nil 0 0		|| check whether pattern is also _Nil
			jmp_true _isMatch61
			jmp _noMatch61

	:_isConsTag1
			eq_desc _Cons 2 0		|| check whether pattern is also _Cons
			jmp_false _noMatch61

	:_compareFirstArgument1
			push_a 2				|| push (a ptr to the) indirectionlist
			push_arg 2 2 1			|| push first argument of type tag	
			push_arg 2 2 1			|| push first argument of type pattern
	.d 3 0
			jsr _unify_types1
	.o 1 1 b
			update_a 0 3			|| update (ptr to the) indirectionlist
			pop_a 1					|| pop (ptr to the) indirectionlist
			jmp_false _noMatch61
	:_compareRestOfArguments1
			push_arg 1 2 2			|| push next arguments of type tag	
			push_arg 1 2 2			|| push next arguments of type pattern
			update_a 1 3
			update_a 0 2
			pop_a 2
			jmp _checkArgumentList1

	||======================================
	||   substitute type pattern variable
	||======================================
	:_substitutePatternVariable1
								|| ind_list              | tag | pat=var
			push_a 2			|| ind_list              | tag | pattern | ind_list
			push_a 1			|| ind_list              | tag | pattern | ind_list | pattern
			build _Cons 2 _hnf	|| ind_list              | tag | pattern | Cons pattern ind_list
			update_a 0 3		|| Cons pattern ind_list | tag | pattern | Cons pattern ind_list
			pop_a 1				|| Cons pattern ind_list | tag | pattern
			fill_a 1 0			|| Cons pattern ind_list | tag | tag
			jmp _isMatch31



	||======================================
	||   substitute type tag variable
	||======================================
	:_substituteTagVariable1
	||			buildAC "StdDynamics:shit\n"
				jmp _noMatch31

	||	:_substituteTagVariable1
	||		print "_substituteTagVariable\n"
								|| ind_list          | tag=var | pattern	
	||			push_a 2			|| ind_list          | tag     | pattern | ind_list
	||			push_a 2			|| ind_list          | tag     | pattern | ind_list | tag
	||			build _Cons 2 _hnf	|| ind_list          | tag     | pattern | Cons tag ind_list
	||			update_a 0 3		|| Cons tag ind_list | tag     | pattern | Cons tag ind_list
	||			pop_a 1				|| Cons tag ind_list | tag     | pattern
	||			fill_a 0 1			|| Cons tag ind_list | pattern | pattern
	||			jmp _isMatch31


	||=========================
	||   types are unifiable
	||=========================
	:_isMatch61
			update_a 2 5			|| copy indirectionpointer
			pop_a 3					|| remove arguments
	:_isMatch31
			pop_a 2					|| remove types
			pushB TRUE
	.d 1 1 b
			rtn
	||=============================
	||   types are not unifiable
	||=============================
	:_noMatch61
			update_a 2 5			|| copy indirectionpointer
			pop_a 3					|| remove arguments
	:_noMatch31
			pop_a 2					|| remove types
			pushB FALSE
	.d 1 1 b
			rtn
	||===================
	||   unknown value
	||===================
	:_unknownValue1
			buildAC "StdDynamics: Unknown Value in dynamic"
			jmp _maRCo_abort1
	}

/****************************************************************************************\
****
****			U n d o   I n d i r e c t i o n s
****
\****************************************************************************************/

_undo_indirections :: a ![T_ypeObjectType] -> a
_undo_indirections x list = code {
	.o 2 0												||  list | x
	:_undo_indirections
	||		print "_undo_indirections\n"
			push_a 1									||  list | x | list			
	:_undo_indirection_loop
			eq_desc _Nil 0 0
			jmp_true _end_undo_indirection_loop			||  list | x | Nil
			eq_desc _Cons 2 0
			jmp_true _undo_this_indirection				||  list | x | Cons T Next
			buildAC "StdDynamics: Unknown Descriptor in indirectionlist"
			jmp _maRCo_abort
	
	:_undo_this_indirection								||  list | x | Cons T next
			push_arg 0 2 1								||  list | x | Cons T next | T
			push_a 0									||  list | x | Cons T next | T | T
			push_a 1									||  list | x | Cons T next | T | T
			fill e_StdDynamic_dP_laceholder 2 _hnf 1	||  list | x | Cons T next | P_laceholder T T
			push_arg 1 2 2								||  list | x | Cons T next | P_laceholder T T | next
			update_a 0 2								||  list | x | next        | P_laceholder T T | next
	.keep 1 2
			pop_a 2										||  list | x | next
			jmp _undo_indirection_loop
	
	:_end_undo_indirection_loop							||  list | x | Nil
			update_a 1 2								||  x | x | Nil
			pop_a 2										||  x
			jsr_eval 0
	.d 1 0
			rtn
}

// file_name should contain an *absolute* path
readDynamic :: String *f -> (Bool,Dynamic,*f) | FileSystem f
readDynamic file_name files
	= abort "readDynamic";

writeDynamic :: String Dynamic *f -> (Bool,*f) | FileSystem f
writeDynamic _ _ _
	= abort "writeDynamic";
	
:: DynamicTemp = E.a: {
		value	:: a
	,	type	:: T_ypeObjectType
	}
